/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.internal.StreamsProxy;
import com.aptana.js.debug.core.internal.model.Messages;
import com.aptana.js.debug.core.model.xhr.IXHRService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDebugProcess
extends PlatformObject
implements IProcess {
    private static final int MAX_WAIT_FOR_DEATH_ATTEMPTS = 10;
    private static final int TIME_TO_WAIT_FOR_THREAD_DEATH = 500;
    private final ILaunch launch;
    private final String label;
    private final Process process;
    private boolean killProcessOnTerminate;
    private volatile boolean processTerminated;
    private ProcessMonitorThread processMonitorThread;
    private IStreamsProxy streamsProxy;
    private Map<String, PipedOutputStream> streams = new HashMap<String, PipedOutputStream>();
    private IDebugTarget debugTarget;
    private IXHRService xhrService;
    private Map<String, String> fAttributes;

    public JSDebugProcess(ILaunch launch, String label, Map<String, Object> attributes) {
        this(launch, null, false, label, attributes);
    }

    public JSDebugProcess(ILaunch launch, Process process, String label, Map<String, Object> attributes) {
        this(launch, process, true, label, attributes);
    }

    public JSDebugProcess(ILaunch launch, Process process, boolean killProcessOnTerminate, String label, Map<String, Object> attributes) {
        this.launch = launch;
        this.process = process;
        this.killProcessOnTerminate = killProcessOnTerminate;
        this.label = label;
        this.initializeAttributes(attributes);
        this.createStreams();
        launch.addProcess((IProcess)this);
        this.fireCreationEvent();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)new DebugEventSetListener());
        if (process != null) {
            try {
                process.exitValue();
                this.processTerminated = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            if (this.processTerminated) {
                this.fireTerminateEvent();
            } else {
                this.processMonitorThread = new ProcessMonitorThread();
                this.processMonitorThread.start();
            }
        }
    }

    protected void createStreams() {
        this.createStream("ID_STANDARD_OUTPUT_STREAM");
        this.createStream("ID_STANDARD_ERROR_STREAM");
        this.createStream("ID_WARNING_STREAM");
        this.getStreamsProxy();
    }

    protected final void createStream(String streamIdentifier) {
        this.streams.put(streamIdentifier, new PipedOutputStream());
    }

    public String getLabel() {
        return this.label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public synchronized IStreamsProxy getStreamsProxy() {
        if (this.streamsProxy == null) {
            try {
                HashMap<String, InputStream> inputs = new HashMap<String, InputStream>();
                for (Map.Entry<String, PipedOutputStream> entry : this.streams.entrySet()) {
                    inputs.put(entry.getKey(), new PipedInputStream(entry.getValue()));
                }
                this.streamsProxy = this.createStreamsProxy(inputs);
            }
            catch (IOException e) {
                JSDebugPlugin.log(e);
            }
        }
        return this.streamsProxy;
    }

    protected StreamsProxy createStreamsProxy(Map<String, InputStream> inputs) {
        return new StreamsProxy(inputs, this);
    }

    public void setAttribute(String key, String value) {
        String origVal;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, String>(5);
        }
        if ((origVal = this.fAttributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.fAttributes.put(key, value);
        this.fireChangeEvent();
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return this.fAttributes.get(key);
    }

    public int getExitValue() throws DebugException {
        if (!this.isTerminated()) {
            this.throwDebugException(null);
        }
        if (this.process != null) {
            return this.process.exitValue();
        }
        return -1;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        if (this.process != null) {
            return this.processTerminated;
        }
        IDebugTarget target = this.getDebugTarget();
        if (target != null) {
            return target.isTerminated();
        }
        return this.processTerminated;
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            IDebugTarget target = this.getDebugTarget();
            if (target != null) {
                target.terminate();
            }
            this.terminateProcess();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IProcess.class) {
            return this;
        }
        if (adapter == IDebugTarget.class) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
            int n = iDebugTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget target = iDebugTargetArray[n2];
                if (((Object)((Object)this)).equals(target.getProcess())) {
                    return target;
                }
                ++n2;
            }
            return null;
        }
        if (adapter == IXHRService.class) {
            return this.xhrService;
        }
        return super.getAdapter(adapter);
    }

    OutputStream getStream(String streamIdentifier) {
        return this.streams.get(streamIdentifier);
    }

    void setDebugTarget(IDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
    }

    void setXHRService(IXHRService xhrService) {
        this.xhrService = xhrService;
    }

    private void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    private void fireTerminateEvent() {
        if (DebugPlugin.getDefault() != null) {
            this.fireEvent(new DebugEvent((Object)this, 8));
        }
    }

    private void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    private void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    private void throwDebugException(Exception exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "com.aptana.js.debug.core", 5012, "", (Throwable)exception));
    }

    private void initializeAttributes(Map<String, Object> attributes) {
        this.setAttribute(IProcess.ATTR_PROCESS_TYPE, "javascript");
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.setAttribute(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
    }

    private void terminateProcess() throws DebugException {
        if (this.process == null) {
            this.processTerminated = true;
        } else if (!this.processTerminated && this.killProcessOnTerminate) {
            this.process.destroy();
            int attempts = 0;
            while (attempts < 10) {
                try {
                    this.process.exitValue();
                    this.processTerminated = true;
                    this.processMonitorThread.interrupt();
                    return;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++attempts;
                }
            }
            throw new DebugException((IStatus)new Status(4, "com.aptana.js.debug.core", 5010, Messages.JSDebugProcess_Terminate_Failed, null));
        }
    }

    private void closeStreams() {
        for (OutputStream outputStream : this.streams.values()) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.streams.clear();
    }

    private IDebugTarget getDebugTarget() {
        if (this.debugTarget == null) {
            this.debugTarget = this.launch.getDebugTarget();
        }
        return this.debugTarget;
    }

    private class DebugEventSetListener
    implements IDebugEventSetListener {
        private DebugEventSetListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = debugEventArray[n2];
                switch (event.getKind()) {
                    case 8: {
                        Object source = event.getSource();
                        if (!source.equals(JSDebugProcess.this.getDebugTarget())) break;
                        JSDebugProcess.this.closeStreams();
                        JSDebugProcess.this.fireTerminateEvent();
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        try {
                            JSDebugProcess.this.terminateProcess();
                            break;
                        }
                        catch (DebugException e) {
                            JSDebugPlugin.log(e);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private class ProcessMonitorThread
    extends Thread {
        public ProcessMonitorThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (!JSDebugProcess.this.processTerminated) {
                try {
                    try {
                        JSDebugProcess.this.process.waitFor();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        JSDebugProcess.this.processTerminated = true;
                        JSDebugProcess.this.fireTerminateEvent();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    JSDebugProcess.this.processTerminated = true;
                    JSDebugProcess.this.fireTerminateEvent();
                    throw throwable;
                }
                JSDebugProcess.this.processTerminated = true;
                JSDebugProcess.this.fireTerminateEvent();
            }
        }
    }
}

